// Aeronautica Militare Italiana AMX-T by colorchanger -- versione 1.0

// some basic defines
#define TEast 0
#define TWest 1
#define TGuerrila 2
#define TCivilian 3
#define TSideUnknown 4
#define TEnemy 5
#define TFriendly 6
#define TLogic 7

#define true 1
#define false 0

// type scope
#define private 0
#define protected 1
#define public 2

class CfgPatches
{
	class ITA_AMX
	{
		units[] = {ITA_AMX_AA, ITA_AMX_M, ITA_AMX_R, ITA_AMX_B};
		weapons[] = {ITA_sidewinder,ITA_MaverickLauncher, ITA_M61_20mm,ITA_Mk82_Launcher_3, ITA_Mk82_Launcher_5, ITA_Razzi_Launcher};
		requiredVersion = 1.30;
	};
};


class CfgAmmo
{
	class Default {};
	class AT3: Default {};
	class CarlGustav: AT3 {};
 	class AA : CarlGustav {};
	class ITA_aim9l : AA
	{


		minRange=100;			
       	 	minRangeProbab=0.8;		
        	midRange=500;			
        	midRangeProbab=1.0;		
        	maxRange=2000;			
        	maxRangeProbab=1.0;		
		airLock=1;
		irLock=0;
		initTime=0.5;
		ThrustTime=100;
		thrust=1000;
		maxspeed=1400;
		hit=100;indirectHit=80;indirectHitRange=3;		
		model = "\ITA_AMX\ITA_aim9l";
		proxyShape="\ITA_AMX\ITA_aim9l";
		manualControl=false;
		maxControlRange=1000;
		maneuvrability=100.0;


	};




	class Hellfire: AT3 {};
	class ITA_Maverick: Hellfire // A10 AT
	{
		hit=1900;indirectHit=800;indirectHitRange=2.5;
		model = Maverik.p3d;
		minRange=200;minRangeProbab=0.30;
		midRange=600;midRangeProbab=0.80;
		maxRange=2000;maxRangeProbab=0.50;
		thrust=700;
		laserLock=false;
		proxyShape = Maverik_Proxy.p3d;
	};




	class ITA_Mk82 : default
	{
		hit=1015;indirectHit=711;indirectHitRange=10;
		minRange=300;minRangeProbab=0.50;
		midRange=800;midRangeProbab=0.95;
		maxRange=2000;maxRangeProbab=0.50;
		soundHit[]={\LaserGuided\expl2,db40,1};
		soundFly[]={"\ITA_AMX\bmbfall.ogg",db-30,1.5};
		cost=20000;
		model="\ITA_AMX\ITA_MK82.p3d";
		proxyShape ="\ITA_AMX\ITA_MK82.p3d";
		irLock=true;
		laserLock=false;
		maxControlRange=20000; 
		maneuvrability=15.0;
		sideAirFriction=0.20;
		simulation=shotMissile;
		maxSpeed=100;
		initTime=1000;
		thrustTime=0;
		thrust=0;
	};


	class ITA_Razzi : Hellfire // rocket (unguided)
	{
		
		proxyShape = ZUNI;
		hit=400;indirectHit=250;indirectHitRange=3;
		minRange=50;minRangeProbab=0.20;
		midRange=250;midRangeProbab=0.20;
		maxRange=1000;maxRangeProbab=0.05;
		maxSpeed=1000;
		simulation=shotRocket;
		simulationStep=0.05;
		//soundHit[]={Explosions\hellfire,db80,1};
		cost=2000;
		soundHit[]={Explosions\expl1,db80,1};
		model = ZUNI;
		irLock=false;
		laserLock=false;
		maneuvrability=0.0;
		maxControlRange=0; // max range for manual control

		initTime=0.05;
		thrustTime=3.5;
		thrust=500;
	};


	class BulletSingle: default {};
	class ExplosiveBullet: BulletSingle {};
	class Bullet30: ExplosiveBullet {};
	class ITA_M61Bullet20: Bullet30 {
		hit=30;
		indirectHit=10;
		explosive=0;		
	};
};

class CfgWeapons
{
	class Default {};
	class LAWLauncher: Default {};
	class CarlGustavLauncher : LAWLauncher {};
	class AT3Launcher: CarlGustavLauncher {};
	class HellfireLauncher: AT3Launcher {};
	class MaverickLauncher: HellfireLauncher {};

	class ITA_sidewinder: MaverickLauncher
	{
		
		ammo=ITA_aim9l;
		displayName="AIM-9L Sidewinder";
		displayNameMagazine="Sidewinder";
		shortNameMagazine="AIM-9L";
		count=6;
		initspeed=15;	
		model = "\ITA_AMX\ITA_aim9l";	
		canLock=2;		
		sound[]={Weapons\Missile,db+18,1};
		aiRateOfFire=12.000000;
		aiRateOfFireDistance=2500;
	};


	class ITA_MaverickLauncher: MaverickLauncher
	{

		ammo=ITA_Maverick;
		displayName=$STR_DN_MAVERICK;
		displayNameMagazine=$STR_MN_MAVERICK;
		shortNameMagazine=$STR_SN_MAVERICK;
		count=5;
		reloadTime=0.5;
		sound[]={Weapons\Missile,db+20,1};
		reloadSound[]={,0,1};
		initSpeed=0;

	};


	class ITA_Mk82_Launcher_5 : HellfireLauncher	// Mk82
	{
		ammo=ITA_Mk82;
		displayName="Mk82";
		displayNameMagazine="Mk82";
		shortNameMagazine="Mk82";
		count=5;
		reloadTime=0.5;
		sound[]={"\sound\weapons\AK74dry",db-50,1.0};
		initSpeed=0;
		canLock=2;
		burst=1;
		aiRateOfFire=8.0;
		aiRateOfFireDistance=2500;
	};

	class ITA_Mk82_Launcher_3 : ITA_Mk82_Launcher_5	// Mk82
	{
		count=3;
	};


	class ITA_Razzi_Launcher: AT3Launcher
	{
		//--
		scopeWeapon = public;
		scopeMagazine = public;

		ammo=ITA_Razzi;
		displayName="RAZZI";
		displayNameMagazine="RAZZI";
		shortNameMagazine="RAZZI";
		count=38;
		reloadTime=0.1;
		aiRateOfFire=0.4; // delay between shots at given distance
		aiRateOfFireDistance=1000; // at shorter distance delay goes lineary to zero
		sound[]={Weapons\rocket1,db+60,1};
		reloadSound[]={Weapons\missload,db-70,1};
		initSpeed=44;
//		magazine=4;
		magazineReloadTime=0.1;
		autoFire = true;
	};


	
	class MGun: Default {};
	class MachineGun7_6: MGun {};
	class MachineGun30: MachineGun7_6 {};
	class ITA_M61_20mm: MachineGun30
	{
	//	dispersion=0.01500;
		displayName="20mm M61 Vulcan";
		displayNameMagazine="20mm M61 Vulcan mag";
		shortNameMagazine="20mm mag";
		ammo="ITA_M61Bullet20";
		count=500;
		reloadTime=0.07000;
		initSpeed=2000;
		sound[]={"Weapons\automatic_cannon",3.162278,1};
		soundContinuous=0;
		flashSize=0.000000;
		maxLeadSpeed=1800;
		optics=1;
	};	
};


class CfgVehicles
{
	class All {};
	class AllVehicles: All {};
	class Air: AllVehicles {};
	class Plane: Air {};

	class ITA_AMX_AA: Plane
	{
		scope=public;
		crew = ITA_Pilot;
		picture = \ITA_AMX\icon;
		side = 1;
		displayName="ITA A.M.I. AMX AA";
		accuracy=0.30;
		
		irTarget=1;
		irScanRange=4000;
		irScanGround=1;
		
		driverAction = ManActA10Pilot;
		cargoAction[]={"ManActCessnaCargo"};
		maxSpeed = 980;
		
		soundEngine[]={"Vehicles\01F5",20.200000,1.000000};
		
		weapons[]={ ITA_M61_20mm, ITA_sidewinder };
		magazines[]={ ITA_M61_20mm, ITA_sidewinder };

		armor=60;
		cost=20000;
		transportSoldier=1;
		model="\ITA_AMX\ITA_AMX_AA.p3d";

		fov=0.5;

		type=VAir;
		//threat[] VSoft, VArmor, VAir 
		threat[]={0.2, 0.2, 1.0};
	};


	class ITA_AMX_AGB: Plane
	{
		scope=public;
		crew = ITA_Pilot;
		picture = \ITA_AMX\icon;
		side = 1;
		displayName="ITA A.M.I. AMX B";
		accuracy=0.30;
		
		irTarget=1;
		irScanRange=4000;
		irScanGround=1;
		
		driverAction = ManActA10Pilot;
		cargoAction[]={"ManActCessnaCargo"};
		maxSpeed = 980;
		
		soundEngine[]={"Vehicles\01F5",20.200000,1.000000};
		
		weapons[]={ ITA_M61_20mm, ITA_Mk82_Launcher_5 };
		magazines[]={ ITA_M61_20mm, ITA_Mk82_Launcher_5 };

		armor=60;
		cost=20000;
		transportSoldier=1;
		model="\ITA_AMX\ITA_AMX_AGM.p3d";

		fov=0.5;

		type=VAir;
		//threat[] VSoft, VArmor, VAir 
		threat[]={0.9, 1.0, 0.5};
	};


	class ITA_AMX_AGM: Plane
	{
		scope=public;
		crew = ITA_Pilot;
		picture = \ITA_AMX\icon;
		side = 1;
		displayName="ITA A.M.I. AMX M";
		accuracy=0.30;
		
		irTarget=1;
		irScanRange=4000;
		irScanGround=1;
		
		driverAction = ManActA10Pilot;
		cargoAction[]={"ManActCessnaCargo"};
		maxSpeed = 980;
		
		soundEngine[]={"Vehicles\01F5",20.200000,1.000000};
		
		weapons[]={ ITA_M61_20mm, ITA_MaverickLauncher };
		magazines[]={ ITA_M61_20mm, ITA_MaverickLauncher };

		armor=60;
		cost=20000;
		transportSoldier=1;
		model="\ITA_AMX\ITA_AMX_AGM.p3d";

		fov=0.5;

		type=VAir;
		//threat[] VSoft, VArmor, VAir 
		threat[]={0.9, 1.0, 0.5};
	};



	class ITA_AMX_AGR: Plane
	{
		scope=public;
		crew = ITA_Pilot;
		picture = \ITA_AMX\icon;
		side = 1;
		displayName="ITA A.M.I. AMX R";
		accuracy=0.30;
		
		irTarget=1;
		irScanRange=4000;
		irScanGround=1;
		
		driverAction = ManActA10Pilot;
		cargoAction[]={"ManActCessnaCargo"};
		maxSpeed = 980;
		
		soundEngine[]={"Vehicles\01F5",20.200000,1.000000};
		
		weapons[]={ ITA_M61_20mm, ITA_Razzi_Launcher, ITA_Mk82_Launcher_3};
		magazines[]={ ITA_M61_20mm, ITA_Razzi_Launcher, ITA_Mk82_Launcher_3};

		armor=60;
		cost=20000;
		transportSoldier=1;
		model="\ITA_AMX\ITA_AMX_AGR.p3d";

		fov=0.5;

		type=VAir;
		//threat[] VSoft, VArmor, VAir 
		threat[]={1.0, 1.0, 0.5};
	};


};


class CfgNonAIVehicles
{
	class ProxyWeapon {};
	class ProxyITA_aim9l : ProxyWeapon {model = "\ITA_AMX\ITA_aim9l"; simulation = "maverickweapon";}
	class ProxyITA_maverick : ProxyWeapon {model = Maverik; simulation = "maverickweapon";}
	class ProxyITA_Razzi : ProxyWeapon {model = zuni; simulation = "maverickweapon";}
};

