// M4A1 Carabine P3D MOD; updated final version (v2.1)
// by FlipeR[SV] (www.natosoldier.com)
// some basic defines
#define TEast 0
#define TWest 1
#define TGuerrila 2
#define TCivilian 3
#define TSideUnknown 4
#define TEnemy 5
#define TFriendly 6
#define TLogic 7

#define true 1
#define false 0

// type scope
#define private 0
#define protected 1
#define public 2

#define WeaponNoSlot			0// dummy weapons
#define WeaponSlotPrimary		1// primary weapons
#define WeaponSlotSecondary		16// secondary weapons
#define WeaponSlotItem			256// items
#define WeaponSlotBinocular		4096// binocular
#define WeaponHardMounted		65536


class CfgPatches
{
	class FLPM4A1
	{
		units[] = {FLPSoldierWM4A1,FLPSoldierWM4A12xMag,FLPSoldierWM4A1CMag,FLPSoldierWM4A1Desert};
		weapons[] = {FLPM4A1,FLPM4A12xMag,FLPM4A1CMag,FLPM4A1Desert};
		requiredVersion = 1.75;
	};

	class FLPM4A1M203
	{
		units[] = {FLPSoldierWM4A1M203,FLPSoldierWM4A1M2032xMag,FLPSoldierWM4A1M203CMag};
		weapons[] = {FLPM4A1M203,FLPM4A1M2032xMag,FLPM4A1M203CMag};
		requiredVersion = 1.75;
	};

	class FLPM4A1SD
	{
		units[] = {FLPSoldierWM4A1SD,FLPSoldierWM4A1SD2xMag,FLPSoldierWM4A1SDCMag};
		weapons[] = {FLPM4A1SD,FLPM4A1SD2xMag,FLPM4A1SDCMag};
		requiredVersion = 1.75;
	};

	class FLPM4A1M203SD
	{
		units[] = {FLPSoldierWM4A1M203SD,FLPSoldierWM4A1M203SD2xMag,FLPSoldierWM4A1M203SDCMag};
		weapons[] = {FLPM4A1M203SD,FLPM4A1M203SD2xMag,FLPM4A1M203SDCMag};
		requiredVersion = 1.75;
	};

	class FLP_M4Box
	{
		units[]={"FLP_M4Box"};
		weapons[]={};
		requiredVersion=1.75;
	};
};


///CfgModels definitions
class CfgModels
{
	class Default{};
	class Weapon: Default{};
	class FLP_M4A1_proxy: Weapon{};
	class FLP_M4A1_2X_proxy: Weapon{};
	class FLP_M4A1_CMag_proxy: Weapon{};
	class FLP_M4A1_SD_proxy: Weapon{};
	class FLP_M4A1_SD_2X_proxy: Weapon{};
	class FLP_M4A1_SD_CMag_proxy: Weapon{};
	class FLP_M4A1_M203_proxy: Weapon{};
	class FLP_M4A1_M203_2X_proxy: Weapon{};
	class FLP_M4A1_M203_CMag_proxy: Weapon{};
	class FLP_M4A1_M203_SD_proxy: Weapon{};
	class FLP_M4A1_M203_SD_2X_proxy: Weapon{};
	class FLP_M4A1_M203_SD_CMag_proxy: Weapon{};
	class FLP_M4A1_Des_proxy: Weapon{};
};


///Ammo definitions;
class CfgAmmo
{
	class Default{};
	class BulletSingle: Default{};
	class BulletSingleW: BulletSingle{};
	class FLP_BulletSilencedSingleW: BulletSingleW
	{
		indirectHitRange=0.100000;
		visibleFire=0.055000;
		audibleFire=0.055000;
		visibleFireTime=2;
		tracerColor[]={0,0,0,0.005000};
		tracerColorR[]={0,0,0,0.005000};
	};

	class BulletBurst: BulletSingle{};
	class BulletFullAuto: BulletBurst{};
	class BulletFullAutoW: BulletFullAuto{};
	class FLP_BulletSilencedFullAutoW: BulletFullAutoW
	{
		indirectHitRange=0.100000;
		visibleFire=0.070000;
		audibleFire=0.070000;
		visibleFireTime=3;
		tracerColor[]={0,0,0,0.005000};
		tracerColorR[]={0,0,0,0.005000};
	};
};


///Weapon definitions;
class CfgWeapons
{
	class Default	{};
	class MGun: Default {};
	class Riffle: MGun {};


	///M4A1 basic;
	class FLPM4A1: Riffle
	{
		scopeWeapon=2;
		scopeMagazine=0;
		displayName="M4A1";
		model="\FLP_M4A1\FLP_M4A1_proxy.p3d";
		modelOptics="optika_m16";
		picture="\FLP_M4A1\weapics\w_m4a1.paa";
		optics=true;
		opticsZoomMin=0.35;
		opticsZoomMax=0.35;
		magazines[]={FLPM4A1mag};
		reloadMagazineSound[]={"\FLP_M4A1\sound\m4a1_reload.wav",1.000000,1};
		modes[]={"Single","FullAuto"};
		class Single
		{
			ammo="BulletSingleW";
			multiplier=1;
			burst=1;

			displayName="M4A1 Semi";

			dispersion=0.002000;
			sound[]={"\FLP_M4A1\sound\m4a1.wav",1.000000,1};
			soundContinuous=0;
			reloadTime=0.150000;
			ffCount=1;
			recoil="riffleSingle";
			autoFire=0;
			aiRateOfFire=5.000000;
			aiRateOfFireDistance=500;
			useAction=0;
			useActionTitle="";
		};
		class FullAuto
		{
			ammo="BulletFullAutoW";
			multiplier=1;
			burst=1;

			displayName="M4A1 Auto";

			dispersion=0.004000;
			sound[]={"\FLP_M4A1\sound\m4a1.wav",1.000000,1};
			soundContinuous=0;
			reloadTime=0.100000;
			ffCount=100;
			recoil="riffleBurst3";
			autoFire=1;
			aiRateOfFire=5.000000;
			aiRateOfFireDistance=500;
			useAction=0;
			useActionTitle="";
		};
	};

	class FLPM4A12xMag: FLPM4A1
	{
		scopeWeapon=2;
		scopeMagazine=0;
		displayName="M4A1 (2xMag)";
		model="\FLP_M4A1\FLP_M4A1_2X_proxy.p3d";
	};

	class FLPM4A1CMag: FLPM4A1
	{
		scopeWeapon=2;
		scopeMagazine=0;
		displayName="M4A1 (C-Mag)";
		model="\FLP_M4A1\FLP_M4A1_CMag_proxy.p3d";
		magazines[]={FLPM4A1BCmag};
		modes[]={"Single","FullAuto"};
		class Single
		{
			ammo="BulletSingleW";
			multiplier=1;
			burst=1;
			displayName="M4A1 Semi";
			dispersion=0.002000;
			sound[]={"\FLP_M4A1\sound\m4a1.wav",1.000000,1};
			soundContinuous=0;
			reloadTime=0.150000;
			ffCount=1;
			recoil="riffleSingle";
			autoFire=0;
			aiRateOfFire=3.500000;
			aiRateOfFireDistance=650;
			useAction=0;
			useActionTitle="";
		};
		class FullAuto
		{
			ammo="BulletFullAutoW";
			multiplier=1;
			burst=1;
			displayName="M4A1 Auto";
			dispersion=0.004500;
			sound[]={"\FLP_M4A1\sound\m4a1.wav",1.000000,1};
			soundContinuous=0;
			reloadTime=0.100000;
			ffCount=100;
			recoil="riffleBurst3";
			autoFire=1;
			aiRateOfFire=1.000000;
			aiRateOfFireDistance=550;
			useAction=0;
			useActionTitle="";
		};
	};

	class FLPM4A1Desert: FLPM4A1
	{
		scopeWeapon=2;
		scopeMagazine=0;
		displayName="M4A1 Desert";
		model="\FLP_M4A1\FLP_M4A1_Des_proxy.p3d";
	};


	///M4A1+M203;
	class FLPM4A1M203
	{
		scopeWeapon=2;
		scopeMagazine=0;
		weaponType=1;
		displayName="M4A1 w/M203";
		model="\FLP_M4A1\FLP_M4A1_M203_proxy.p3d";
		picture="\FLP_M4A1\weapics\w_m4a1gl.paa";
		muzzles[]={"M4A1Muzzle","M203Muzzle"};
		class M4A1Muzzle: FLPM4A1
		{
		};
		class GrenadeLauncher: Default {};
		class M203Muzzle: GrenadeLauncher
		{
			cursor="t_select.paa";
			scopeMagazine=2;
			weaponType=0;
			count=1;
			autoReload=0;
			ffMagnitude=0.100000;
			ffFrequency=1;
			ffCount=1;
			optics=1;
			modelOptics="\FLP_M4A1\scopes\STTm16_optika_gl.p3d";
			opticsZoomMin=0.500000;
			opticsZoomMax=0.500000;
			muzzlePos="usti granatometu";
			muzzleEnd="konec granatometu";
			magazines[]={"GrenadeLauncher","Flare","FlareGreen","FlareRed","FlareYellow"};
		};
	};

	class FLPM4A1M2032xMag: FLPM4A1M203
	{
		scopeWeapon=2;
		scopeMagazine=0;
		displayName="M4A1 w/M203 (2xMag)";
		model="\FLP_M4A1\FLP_M4A1_M203_2X_proxy.p3d";
		muzzles[]={"M4A12xMagMuzzle","M203Muzzle"};
		class M4A12xMagMuzzle: FLPM4A12xMag
		{
		};
	};

	class FLPM4A1M203CMag: FLPM4A1M203
	{
		scopeWeapon=2;
		scopeMagazine=0;
		displayName="M4A1 w/M203 (C-Mag)";
		model="\FLP_M4A1\FLP_M4A1_M203_CMag_proxy.p3d";
		muzzles[]={"M4A1CMagMuzzle","M203Muzzle"};
		class M4A1CMagMuzzle: FLPM4A1CMag
		{
		};
	};


	///M4A1+m4 Suppressor;
	class FLPM4A1SD: Riffle
	{
		scopeWeapon=2;
		scopeMagazine=0;
		weaponType=1;
		displayName="M4A1 SD";
		model="\FLP_M4A1\FLP_M4A1_SD_proxy.p3d";
		modelOptics="optika_m16";
		picture="\FLP_M4A1\weapics\w_m4a1_sd.paa";
		optics=true;
		opticsZoomMin=0.35;
		opticsZoomMax=0.35;
		magazines[]={FLPM4A1SDmag};
		reloadMagazineSound[]={"\FLP_M4A1\sound\m4a1_reload.wav",1.000000,1};
		modes[]={"Single","FullAuto"};
		class Single
		{
			ammo="FLP_BulletSilencedSingleW";
			multiplier=1;
			burst=1;

			displayName="M4A1SD Semi";

			dispersion=0.002800;
			sound[]={"\FLP_M4A1\sound\m4a1_sd.wav",0.000500,1};
			soundContinuous=0;
			reloadTime=0.150000;
			ffCount=1;
			recoil="riffleSingle";
			autoFire=0;
			aiRateOfFire=5.000000;
			aiRateOfFireDistance=500;
			useAction=0;
			useActionTitle="";
		};
		class FullAuto
		{
			ammo="FLP_BulletSilencedFullAutoW";
			multiplier=1;
			burst=1;

			displayName="M4A1SD Auto";

			dispersion=0.0051000;
			sound[]={"\FLP_M4A1\sound\m4a1_sd.wav",0.000500,1};
			soundContinuous=0;
			reloadTime=0.100000;
			ffCount=30;
			recoil="riffleBurst3";
			autoFire=1;
			aiRateOfFire=5.000000;
			aiRateOfFireDistance=500;
			useAction=0;
			useActionTitle="";
		};
	};

	class FLPM4A1SD2xMag: FLPM4A1SD
	{
		scopeWeapon=2;
		scopeMagazine=0;
		displayName="M4A1 SD (2xMag)";
		model="\FLP_M4A1\FLP_M4A1_SD_2X_proxy.p3d";
	};

	class FLPM4A1SDCMag: FLPM4A1SD
	{
		scopeWeapon=2;
		scopeMagazine=0;
		displayName="M4A1 SD (C-Mag)";
		model="\FLP_M4A1\FLP_M4A1_SD_CMag_proxy.p3d";
		magazines[]={FLPM4A1SDBCmag};
		modes[]={"Single","FullAuto"};
		class Single
		{
			ammo="FLP_BulletSilencedSingleW";
			multiplier=1;
			burst=1;
			displayName="M4A1SD Semi";
			dispersion=0.003000;
			sound[]={"\FLP_M4A1\sound\m4a1_sd.wav",0.000500,1};
			soundContinuous=0;
			reloadTime=0.150000;
			ffCount=1;
			recoil="riffleSingle";
			autoFire=0;
			aiRateOfFire=3.500000;
			aiRateOfFireDistance=650;
			useAction=0;
			useActionTitle="";
		};
		class FullAuto
		{
			ammo="FLP_BulletSilencedFullAutoW";
			multiplier=1;
			burst=1;
			displayName="M4A1SD Auto";
			dispersion=0.005500;
			sound[]={"\FLP_M4A1\sound\m4a1_sd.wav",0.000500,1};
			soundContinuous=0;
			reloadTime=0.100000;
			ffCount=100;
			recoil="riffleBurst3";
			autoFire=1;
			aiRateOfFire=1.000000;
			aiRateOfFireDistance=550;
			useAction=0;
			useActionTitle="";
		};
	};


	///M4A1+M203+m4 Suppressor;
	class FLPM4A1M203SD
	{
		scopeWeapon=2;
		scopeMagazine=0;
		weaponType=1;
		displayName="M4A1 w/M203 SD";
		model="\FLP_M4A1\FLP_M4A1_M203_SD_proxy.p3d";
		picture="\FLP_M4A1\weapics\w_m4a1gl_sd.paa";
		muzzles[]={"M4A1SDMuzzle","M203Muzzle"};
		class M4A1SDMuzzle: FLPM4A1SD
		{
		};
		class GrenadeLauncher: Default {};
		class M203Muzzle: GrenadeLauncher
		{
			cursor="t_select.paa";
			scopeMagazine=2;
			weaponType=0;
			count=1;
			autoReload=0;
			ffMagnitude=0.100000;
			ffFrequency=1;
			ffCount=1;
			optics=1;
			modelOptics="\FLP_M4A1\scopes\STTm16_optika_gl.p3d";
			opticsZoomMin=0.500000;
			opticsZoomMax=0.500000;
			muzzlePos="usti granatometu";
			muzzleEnd="konec granatometu";
			magazines[]={"GrenadeLauncher","Flare","FlareGreen","FlareRed","FlareYellow"};
		};
	};

	class FLPM4A1M203SD2xMag: FLPM4A1M203SD
	{
		scopeWeapon=2;
		scopeMagazine=0;
		displayName="M4A1 w/M203 SD (2xMag)";
		model="\FLP_M4A1\FLP_M4A1_M203_SD_2X_proxy.p3d";
		muzzles[]={"M4A1SD2xMagMuzzle","M203Muzzle"};
		class M4A1SD2xMagMuzzle: FLPM4A1SD2xMag
		{
		};
	};

	class FLPM4A1M203SDCMag: FLPM4A1M203SD
	{
		scopeWeapon=2;
		scopeMagazine=0;
		displayName="M4A1 w/M203 SD (C-Mag)";
		model="\FLP_M4A1\FLP_M4A1_M203_SD_CMag_proxy.p3d";
		muzzles[]={"M4A1SDCMagMuzzle","M203Muzzle"};
		class M4A1SDCMagMuzzle: FLPM4A1SDCMag
		{
		};
	};


	///Magazine definitions;
	class FLPM4A1mag: FLPM4A1
	{
		displayNameMagazine = M4A1mag;
		shortNameMagazine = M4mag;
		picture="\FLP_M4A1\weapics\m_m4a1.paa";
		count=30;
		scopeWeapon=0;
     		scopeMagazine=2;
	};

	class FLPM4A1BCmag: FLPM4A1
	{
		magazineType="2 * 			256";
		displayNameMagazine = M4A1 C-Mag;
		shortNameMagazine = C-Mag;
		picture="\FLP_M4A1\weapics\m_CMag.paa";
		count=100;
		scopeWeapon=0;
   		scopeMagazine=2;
	};

	class FLPM4A1SDmag: FLPM4A1SD
	{
		displayNameMagazine = M4A1SDmag;
		shortNameMagazine = M4mag;
		picture="\FLP_M4A1\weapics\m_m4a1.paa";
		count=30;
		scopeWeapon=0;
     		scopeMagazine=2;
	};

	class FLPM4A1SDBCmag: FLPM4A1SD
	{
		magazineType="2 * 			256";
		displayNameMagazine = SD C-Mag;
		shortNameMagazine = C-Mag;
		picture="\FLP_M4A1\weapics\m_CMag.paa";
		count=100;
		scopeWeapon=0;
   		scopeMagazine=2;
	};
};


///Soldier definitions;
class CfgVehicles
{
	class All{};
	class Static: All{};
	class Building: Static{};
	class Strategic: Building{};
	class ReammoBox: Strategic{};
	class FLP_M4Box: ReammoBox
	{
		model="\FLP_M4A1\M4Box\M4Box.p3d";
		scope=2;
		side=1;
		accuracy=1000;
		displayName="M4A1 & Ammo Box";
		showWeaponCargo=1;
		class TransportWeapons
		{
			class FLPM4A1
			{
				weapon="FLPM4A1";
				count=5;
			};
			class FLPM4A12xMag
			{
				weapon="FLPM4A12xMag";
				count=0;
			};
			class FLPM4A1CMag
			{
				weapon="FLPM4A1CMag";
				count=0;
			};
		};
		class TransportMagazines
		{
			class _xx_FLPM4A1mag
			{
				magazine="FLPM4A1mag";
				count=100;
			};
			class _xx_FLPM4A1BCmag
			{
				magazine="FLPM4A1BCmag";
				count=20;
			};
		};
	};


	class AllVehicles:All{};
	class Land:AllVehicles{};
	class Man:Land{};
	class Soldier:Man{};
	class SoldierWB:Soldier{};
	class FLPSoldierWM4A1: SoldierWB
	{
	model="mc vojakw2.p3d";
	displayName="Soldier M4A1";
	weapons[]={"FLPM4A1","Binocular","NVGoggles","Throw","Put"};
	magazines[]={FLPM4A1mag,FLPM4A1mag,FLPM4A1mag,FLPM4A1mag,FLPM4A1mag,FLPM4A1mag,HandGrenade,HandGrenade,HandGrenade,SmokeShell};
	};

	class FLPSoldierWM4A12xMag: FLPSoldierWM4A1
	{
	displayName="Soldier M4A1(2xMag)";
	weapons[]={"FLPM4A12xMag","Binocular","NVGoggles","Throw","Put"};
	magazines[]={FLPM4A1mag,FLPM4A1mag,FLPM4A1mag,FLPM4A1mag,FLPM4A1mag,FLPM4A1mag,HandGrenade,HandGrenade,HandGrenade,SmokeShell};
	};

	class FLPSoldierWM4A1CMag: FLPSoldierWM4A1
	{
	displayName="Soldier M4A1(C-Mag)";
	weapons[]={"FLPM4A1CMag","Binocular","NVGoggles","Throw","Put"};
	magazines[]={FLPM4A1BCmag,FLPM4A1BCmag,FLPM4A1BCmag,HandGrenade,HandGrenade,HandGrenade,SmokeShell};
	};

	class FLPSoldierWM4A1Desert: FLPSoldierWM4A1
	{
	displayName="Soldier M4A1 Desert";
	weapons[]={"FLPM4A1Desert","Binocular","NVGoggles","Throw","Put"};
	magazines[]={FLPM4A1mag,FLPM4A1mag,FLPM4A1mag,FLPM4A1mag,FLPM4A1mag,FLPM4A1mag,HandGrenade,HandGrenade,HandGrenade,SmokeShell};
	};

	class FLPSoldierWM4A1M203: FLPSoldierWM4A1
	{
	displayName="Soldier M4A1M203";
	weapons[]={"FLPM4A1M203","Binocular","NVGoggles","Throw","Put"};
	magazines[]={FLPM4A1mag,FLPM4A1mag,FLPM4A1mag,FLPM4A1mag,"GrenadeLauncher","GrenadeLauncher","GrenadeLauncher"};
	};

	class FLPSoldierWM4A1M2032xMag: FLPSoldierWM4A1
	{
	displayName="Soldier M4A1M203(2xMag)";
	weapons[]={"FLPM4A1M2032xMag","Binocular","NVGoggles","Throw","Put"};
	magazines[]={FLPM4A1mag,FLPM4A1mag,FLPM4A1mag,FLPM4A1mag,"GrenadeLauncher","GrenadeLauncher","GrenadeLauncher"};
	};

	class FLPSoldierWM4A1M203CMag: FLPSoldierWM4A1
	{
	displayName="Soldier M4A1M203(C-Mag)";
	weapons[]={"FLPM4A1M203CMag","Binocular","NVGoggles","Throw","Put"};
	magazines[]={FLPM4A1BCmag,FLPM4A1BCmag,FLPM4A1BCmag,"GrenadeLauncher","GrenadeLauncher"};
	};

	class FLPSoldierWM4A1SD: FLPSoldierWM4A1
	{
	displayName="Soldier M4A1SD";
	weapons[]={"FLPM4A1SD","Binocular","NVGoggles","Throw","Put"};
	magazines[]={FLPM4A1SDmag,FLPM4A1SDmag,FLPM4A1SDmag,FLPM4A1SDmag,FLPM4A1SDmag,FLPM4A1SDmag,HandGrenade,HandGrenade,HandGrenade,SmokeShell};
	};

	class FLPSoldierWM4A1SD2xMag: FLPSoldierWM4A1
	{
	displayName="Soldier M4A1SD(2xMag)";
	weapons[]={"FLPM4A1SD2xMag","Binocular","NVGoggles","Throw","Put"};
	magazines[]={FLPM4A1SDmag,FLPM4A1SDmag,FLPM4A1SDmag,FLPM4A1SDmag,FLPM4A1SDmag,FLPM4A1SDmag,HandGrenade,HandGrenade,HandGrenade,SmokeShell};
	};

	class FLPSoldierWM4A1SDCMag: FLPSoldierWM4A1
	{
	displayName="Soldier M4A1SD(C-Mag)";
	weapons[]={"FLPM4A1SDCMag","Binocular","NVGoggles","Throw","Put"};
	magazines[]={FLPM4A1SDBCmag,FLPM4A1SDBCmag,FLPM4A1SDBCmag,HandGrenade,HandGrenade,HandGrenade,SmokeShell};
	};
	class FLPSoldierWM4A1M203SD: FLPSoldierWM4A1
	{
	displayName="Soldier M4A1M203SD";
	weapons[]={"FLPM4A1M203SD","Binocular","NVGoggles","Throw","Put"};
	magazines[]={FLPM4A1SDmag,FLPM4A1SDmag,FLPM4A1SDmag,FLPM4A1SDmag,"GrenadeLauncher","GrenadeLauncher","GrenadeLauncher"};
	};

	class FLPSoldierWM4A1M203SD2xMag: FLPSoldierWM4A1
	{
	displayName="Soldier M4A1M203SD(2xMag)";
	weapons[]={"FLPM4A1M203SD2xMag","Binocular","NVGoggles","Throw","Put"};
	magazines[]={FLPM4A1SDmag,FLPM4A1SDmag,FLPM4A1SDmag,FLPM4A1SDmag,"GrenadeLauncher","GrenadeLauncher","GrenadeLauncher"};
	};

	class FLPSoldierWM4A1M203SDCMag: FLPSoldierWM4A1
	{
	displayName="Soldier M4A1M203SD(C-Mag)";
	weapons[]={"FLPM4A1M203SDCMag","Binocular","NVGoggles","Throw","Put"};
	magazines[]={FLPM4A1SDBCmag,FLPM4A1SDBCmag,FLPM4A1SDBCmag,"GrenadeLauncher","GrenadeLauncher"};
	};
};


class CfgNonAIVehicles
{
	class ProxyWeapon {};
	class ProxyFLPM4A1: ProxyWeapon 
	{
		autocenter=0;
		scope=2;
		reversed=0;
		simulation="ProxyWeapon";
		model="\FLP_M4A1\FLP_M4A1_proxy.p3d";
	};
	class ProxyFLPM4A12xMag: ProxyWeapon
	{
		autocenter=0;
		scope=2;
		reversed=0;
		simulation="ProxyWeapon";
		model="\FLP_M4A1\FLP_M4A_2X_proxy.p3d";
	};
	class ProxyFLPM4A1CMag: ProxyWeapon
	{
		autocenter=0;
		scope=2;
		reversed=0;
		simulation="ProxyWeapon";
		model="\FLP_M4A1\FLP_M4A1_CMag_proxy.p3d";
	};
	class ProxyFLPM4A1M203: ProxyWeapon
	{
		autocenter=0;
		scope=2;
		reversed=0;
		simulation="ProxyWeapon";
		model="\FLP_M4A1\FLP_M4A1_M203_proxy.p3d";
	};
	class ProxyFLPM4A1M2032xMag: ProxyWeapon
	{
		autocenter=0;
		scope=2;
		reversed=0;
		simulation="ProxyWeapon";
		model="\FLP_M4A1\FLP_M4A1_M203_2X_proxy.p3d";
	};
	class ProxyFLPM4A1M203CMag: ProxyWeapon
	{
		autocenter=0;
		scope=2;
		reversed=0;
		simulation="ProxyWeapon";
		model="\FLP_M4A1\FLP_M4A1_M203_CMag_proxy.p3d";
	};
	class ProxyFLPM4A1SD: ProxyWeapon
	{
		autocenter=0;
		scope=2;
		reversed=0;
		simulation="ProxyWeapon";
		model="\FLP_M4A1\FLP_M4A1_SD_proxy.p3d";
	};
	class ProxyFLPM4A1SD2xMag: ProxyWeapon
	{
		autocenter=0;
		scope=2;
		reversed=0;
		simulation="ProxyWeapon";
		model="\FLP_M4A1\FLP_M4A1_SD_2X_proxy.p3d";
	};
	class ProxyFLPM4A1SDCMag: ProxyWeapon
	{
		autocenter=0;
		scope=2;
		reversed=0;
		simulation="ProxyWeapon";
		model="\FLP_M4A1\FLP_M4A1_SD_CMag_proxy.p3d";
	};
	class ProxyFLPM4A1M203SD: ProxyWeapon
	{
		autocenter=0;
		scope=2;
		reversed=0;
		simulation="ProxyWeapon";
		model="\FLP_M4A1\FLP_M4A1_M203_SD_proxy.p3d";
	};
	class ProxyFLPM4A1M203SD2xMag: ProxyWeapon
	{
		autocenter=0;
		scope=2;
		reversed=0;
		simulation="ProxyWeapon";
		model="\FLP_M4A1\FLP_M4A1_M203_SD_2X_proxy.p3d";
	};
	class ProxyFLPM4A1M203SDCMag: ProxyWeapon
	{
		autocenter=0;
		scope=2;
		reversed=0;
		simulation="ProxyWeapon";
		model="\FLP_M4A1\FLP_M4A1_M203_SD_CMag_proxy.p3d";
	};
};  